<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Photo;
use Brian2694\Toastr\Facades\Toastr;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Carbon\Carbon;
use Illuminate\Support\Facades\Storage;
use Intervention\Image\Facades\Image;

class ImageController extends Controller
{
    public function index(){

        $images = Photo::all();

        return view('admin.image',compact('images'));
    }

    public function store(Request $request){
        $this->validate($request, [
            'image' => 'required'
        ]);

        $images = $request->image;
        foreach($images as $image){

            $imageName = uniqid().Carbon::now()->timestamp.'.'.$image->getClientOriginalExtension();
            if(!Storage::disk('public')->exists('post')){
                Storage::disk('public')->makeDirectory('post');
            }
            //Image Croped 
            $img = Image::make($image)->resize(500, 500, function($constraint){
                $constraint->aspectRatio();
                $constraint->upsize();
    
            })->stream();
    
            Storage::disk('public')->put('images/'.$imageName,$img);
            $post = new Photo();
            $post->user_id = Auth::user()->id;
            $post->video = $request->link;
            $post->image = $imageName;
            $post->save();
            
        }
       

        Toastr::success('Image Uploaded successfully');
        return redirect()->route('admin.image');
        // return redirect()->back();

    }


    public function destroy($id){

        $image = Photo::findOrFail($id);
        // delete image if exist
          //Delete old image 
          if(storage::disk('public')->exists('images/'.$image->image)){
            storage::disk('public')->delete('images/'.$image->image);
        }
        //Delete Tags
        $image->delete();

        Toastr::error('Image Deleted successfully', 'success');
        return redirect()->route('admin.image');

    }



    
}
