<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Providers\RouteServiceProvider;
use App\User;
use Illuminate\Foundation\Auth\AuthenticatesUsers;
use Illuminate\Support\Facades\Auth;
use Laravel\Socialite\Facades\Socialite;

class LoginController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Login Controller
    |--------------------------------------------------------------------------
    |
    | This controller handles authenticating users for the application and
    | redirecting them to your home screen. The controller uses a trait
    | to conveniently provide its functionality to your applications.
    |
    */

    use AuthenticatesUsers;

    /**
     * Where to redirect users after login.
     *
     * @var string
     */
    protected $redirectTo = '/';

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('guest')->except('logout');
    }


    public function redirectToProvider()
    {
        return Socialite::driver('google')->redirect();
    }

    /**
     * Obtain the user information from GitHub.
     *
     * @return \Illuminate\Http\Response
     */
    public function handleProviderCallback()
    {
        $user = Socialite::driver('google')->user();

        // dd($user); die;
        //find user
        $authUser = User::where('email',$user->email)->first();
        if($authUser){
            Auth::login($authUser);
            return redirect()->route('home');

        }
        else{
            $newUser = new User();
            $newUser->email = $user->email;
            $newUser->role_id = 4;
            $newUser->name = $user->name;
            $newUser->image = $user->avatar;
            $newUser->userid = $user->id;
            $newUser->password = uniqid(); 
            $newUser->save();

            Auth::login($newUser);
            return redirect()->route('home');
        }

    }




}
