<?php

namespace App\Http\Controllers;

use App\Comment;
use Brian2694\Toastr\Facades\Toastr;
use Illuminate\Support\Facades\Auth;
use Illuminate\Http\Request;

class CommentController extends Controller
{
    public function store(Request $request, $post){
        $this->validate($request, ['comment' => 'required|max:1000']);
        $comment = new Comment();
        $comment->post_id = $post;
        $comment->user_id = Auth::id();
        $comment->comment = $request->comment; 
        $comment->save();

        //success
        Toastr::success('success', 'The comment created successfully :)');
        return redirect()->back();
    }
}
