<?php

namespace App\Http\Controllers;

use App\CommentReply;
use Brian2694\Toastr\Facades\Toastr;
use Illuminate\Support\Facades\Auth;
use Illuminate\Http\Request;

class CommentReplyController extends Controller
{
    public function store(Request $request, $comment){
        
        $this->validate($request, ['message' => 'required|max:1000']);
        // dd($comment); die;
        $commentReply = new CommentReply();
        $commentReply->comment_id = $comment;
        $commentReply->user_id = Auth::id();
        $commentReply->message = $request->message; 

        // dd($commentReply); die;
        $commentReply->save();

        //success
        Toastr::success('success', 'The comment replied successfully :)');
        return redirect()->back();
    }
}
