<?php

namespace App\Http\Controllers\User;

use App\Comment; 
use Brian2694\Toastr\Facades\Toastr;
use Illuminate\Support\Facades\Auth;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class CommentController extends Controller
{
    public function index(){
        $comments = Comment::where('user_id',Auth::id())->latest()->get();
        return view('user.comments.index', compact('comments'));
    }


    public function destroy($id){
        $comment = Comment::findOrFail($id);
        if($comment->user_id == Auth::id()){
            //Delete Replies 
            $replies = CommentReply::where('comment_id',$id)->delete();
            $comment->delete();
            Toastr::success('comment Successfully deleted :)');
            return redirect()->back();
        }else{
            Toastr::success('You can not deleted this comment :(');
            return redirect()->back();
        }

    }
}
