<?php

namespace App\Http\Controllers\User;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Post;
use App\Category;
use Illuminate\Support\Str;
use Carbon\Carbon;
// use App\Mail\NewPost;
use Illuminate\Support\Facades\Storage;
use Intervention\Image\Facades\Image;
use Brian2694\Toastr\Facades\Toastr;
// use Auth;
use App\User;
use Illuminate\Support\Facades\Auth;

// use Mail;

class PostController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $posts = Post::latest()->get();
       
        return view('user.post.index',compact('posts'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $categories = Category::all();
        return view('user.post.create',compact('categories'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request,[
            'title' => 'required|max:255|unique:posts',
            'image' => 'required|mimes:jpg,png,bmp,jpeg',
            'category' => 'required',
            'tags' => 'required',
            'body' => 'required'
        ]);
        $slug = Str::slug($request->title,'-');
        $image = $request->image;
        $imageName = $slug.'-'.uniqid().Carbon::now()->timestamp.'.'.$image->getClientOriginalExtension();
        if(!Storage::disk('public')->exists('post')){
            Storage::disk('public')->makeDirectory('post');
        }
        //Image Croped 
        $img = Image::make($image)->resize(752, null, function($constraint){
            $constraint->aspectRatio();
            $constraint->upsize();

        })->stream();

        Storage::disk('public')->put('post/'.$imageName,$img);
        $post = new Post();
        $post->title = $request->title; 
        $post->user_id = Auth::id(); 
        $post->category_id = $request->category; 
        $post->slug = $slug; 
        $post->image = $imageName; 
        $post->body = $request->body; 
        if(isset($request->status)){
            $post->status = 1;
        }
        $post->save();
        // //notify by mail
        // if($post->status){
        //     $users = User::all();
        //     foreach($users as $user){
        //         Mail::to($user->email)->queue(new NewPost($post));
        //     }
        // }

        $tags = [];
        $stingTags = array_map('trim',explode(',', $request->tags));
        foreach($stingTags as $tag){
            array_push($tags,['name'=>$tag]);
        }
        $post->tags()->createMany($tags);


        Toastr::success('Post created successfully');
        return redirect()->route('user.post.index');

    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $post = Post::findOrFail($id);
        return view('user.post.show',compact('post'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $post = Post::findOrFail($id);
        $categories = Category::all();
        return view('user.post.edit',compact('post','categories'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate($request,[
            'title' => 'required|max:255',
            'image' => 'sometimes|mimes:jpg,png,bmp,jpeg',
            'category' => 'required',
            'tags' => 'required',
            'body' => 'required'
        ]);
        $post = Post::findOrFail($id);
        $slug = Str::slug($request->title,'-');
       if(isset($request->image)){
            $image = $request->image;
            $imageName = $slug.'-'.uniqid().Carbon::now()->timestamp.'.'.$image->getClientOriginalExtension();
            //iamge directory exists
            if(!Storage::disk('public')->exists('post')){
                Storage::disk('public')->makeDirectory('post');
            }
            //Delete old image 
            if(storage::disk('public')->exists('category/'.$post->image)){
                storage::disk('public')->delete('category/'.$post->image);
            }
            $postImage = Image::make($image)->resize(752, null, function($constraint){
                $constraint->aspectRatio();
                $constraint->upsize();

            })->stream();

            //Store in storage public/category
            Storage::disk('public')->put('post/'.$imageName, $postImage);
            
       }else{
           $imageName = $post->image;
       }

        $post->user_id = Auth::id(); 
        $post->category_id = $request->category; 
        $post->title = $request->title;
        $post->slug = $slug; 
        $post->image = $imageName; 
        $post->body = $request->body; 
        if(isset($request->status)){
            $post->status = true;
        }else{
            $post->status = false;
        }
        $post->save();

                // //notify by mail
                // if($post->status){
                //     $users = User::all();
                //     foreach($users as $user){
                //         Mail::to($user->email)->queue(new NewPost($post));
                //     }
                // }

        //Delete old tags
        $post->tags()->delete();


        $tags = [];
        $stingTags = array_map('trim',explode(',', $request->tags));
        foreach($stingTags as $tag){
            array_push($tags,['name'=>$tag]);
        }
        $post->tags()->createMany($tags);



        Toastr::success('Post Update successfully','success');
        return redirect()->route('user.post.index');





    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $post = Post::findOrFail($id);
        // delete image if exist
          //Delete old image 
          if(storage::disk('public')->exists('category/'.$post->image)){
            storage::disk('public')->delete('category/'.$post->image);
        }
        //Delete Tags
        $post->tags()->delete();
        $post->delete();

        Toastr::error('Post Deleted successfully', 'success');
        return redirect()->route('user.post.index');
    }
}
